# Scope Customs Integration Documentation

This documentation consists of the XML schema, a HTML documentation of the schema, mapping descriptions and example messages. The [version history](history.md) provides an overview over the latest changes.

## XML Schemas

The XSD files can be found in the root directory of the ZIP file.

- customsIntegration-v5.xsd

  Describes the <customsIntegration> which is used to transfer data from or to Scope, which is used to create customs procedures and messages.

- customsResponses-v5.xsd

  Describes the response messages Scope can generate if it receives a response from customs authorities.

- customsBase-v5.xsd and customsTypes-v5.xsd

  Contains commonly used data types and structures.

## HTML Documentation

The HTML documentation can be found in the folder "html" in the ZIP file.

Each XSD has its own HTML file with a more human readable version of the XSD.

## Mapping Description

The mapping description can be found in the folder "mappings".

- **Integration** messages, Scope can **process**, are described in the folders with a country code, followed by "integration". E.g. "mappings/DE/integration".
- **Response** messages, Scope can **produce**, are described in the folders with a country code, followed by "responses". E.g. "mappings/DE/responses".
- **Integration** message, Scope can **produce**, are described in the folder "mappings/customsOrder".

Each mapping is an XML file, which contains the complete structure with all supported fields for a specific procedure. Above each XML tag a comment points to the field in Scope UI, where the content of the field will be put.

Example:

    ...
    <!-- Allgemein / Bezugsnummer -->
    <identification>
        <uniqueReference>token</uniqueReference>
    </identification>
    ...

So, the content of the field uniqueReference will be put in the field "Bezugsnummer" of the tab "Allgemein".

## Example Messages

The examples can be found in the folder "examples" in the ZIP file.

The example complement the mapping files. A mapping is not a realistic customs procedure, as it tries to include all possible fields, which might sometimes contradict each other. The examples try to offer more realistic messages. 

## Additional Documentation

- [Templates](templates.md) describes the use of `<useTemplate>` and `<additionalTransmission>`.
